
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Jul 22 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version KMNG_ATP_TST_ManageOp.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "KMNG_Ext_ATP_Acceptance.h"
#include "ExtApp_qa_op_code.h"
#include "KMNG_Ext_ATP_TestVectors.h"
#include "ExtApp_HOST_TST_Message.h"



/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/


/************* Private function prototype ***********************/
/************************ Public Functions ******************************/

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ExtApp_ATP_AES_ActivateKeys      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description: 
 *  This function Is an acceptance test for Key management API's,
 *  implemented as external SEP application.
 *  The function tests the operations on AES keys.                          .
 * Algorithm:       
 * 1. Call the HOSTQA_ATP_Message function to execute test
 * 2. Verify function succeded according to the returned error code                                                                
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_AES_ActivateKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxError_t             TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_AES_ActivateKeys";     
                              
    DxUint32_t            TST_Host_opCode = DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_AES_ActivateKey;
                              
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_Ext_AES_ActivateKeys Test ************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    

	/* calling the AES ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = HOSTQA_ATP_Message(TST_Host_opCode,sizeof(TST_Ext_KeysSym_TestDataStruct),(void*)&SEP_AES_KeysOpSym_TestData[0]);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"HOSTQA_ATP_Message","KMNG_ExtApp_ATP_AES_ActivateKeys",TST_MasterTestName);                   

    return TST_TestStatus;                
    
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ExtApp_ATP_DES_ActivateKeys      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description: 
 *  This function Is an acceptance test for Key management API's,
 *  implemented as external SEP application.
 *  The function tests the operations on DES keys.                          .
 * Algorithm:       
 * 1. Call the HOSTQA_ATP_Message function to execute test
 * 2. Verify function succeded according to the returned error code                                                                
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_DES_ActivateKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxError_t             TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_DES_ActivateKeys";     
                              
    DxUint32_t            TST_Host_opCode = DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_DES_ActivateKey;
                              
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_DES_ActivateKeys Test ************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    

	/* calling the DES ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = HOSTQA_ATP_Message(TST_Host_opCode,sizeof(TST_Ext_KeysSym_TestDataStruct),(void*)&SEP_DES_KeysOpSym_TestData[0]);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"HOSTQA_ATP_Message","KMNG_ExtApp_ATP_DES_ActivateKeys",TST_MasterTestName);                   
	  	
    return TST_TestStatus;        
    
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ExtApp_ATP_HMAC_ActivateKeys      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description: 
 *  This function Is an acceptance test for Key management API's,
 *  implemented as external SEP application.
 *  The function tests the operations on HMAC keys.                          .
 * Algorithm:       
 * 1. Call the HOSTQA_ATP_Message function to execute test
 * 2. Verify function succeded according to the returned error code                                                                
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_HMAC_ActivateKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxError_t             TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_HMAC_ActivateKeys";     
                              
    DxUint32_t            TST_Host_opCode = DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_HMAC_ActivateKey;
                              
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_HMAC_ActivateKeys Test ************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    

	/* calling the HMAC ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = HOSTQA_ATP_Message(TST_Host_opCode,sizeof(TST_Ext_KeysSym_TestDataStruct),(void*)&SEP_HMAC_KeysOpSym_TestData[0]);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"HOSTQA_ATP_Message","KMNG_ExtApp_ATP_HMAC_ActivateKeys",TST_MasterTestName);                   

    return TST_TestStatus;        
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ExtApp_ATP_RSA_V15_ActivateKeys      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description: 
 *  This function Is an acceptance test for Key management API's,
 *  implemented as external SEP application.
 *  The function tests the RSA v15 operations on RSA keys.                          .
 * Algorithm:       
 * 1. Call the HOSTQA_ATP_Message function to execute test
 * 2. Verify function succeded according to the returned error code                                                                
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_RSA_V15_ActivateKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxError_t             TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_RSA_V15_ActivateKeys";     
                              
    DxUint32_t            TST_Host_opCode = DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_V15_ActivateKey;
                              
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_RSA_V15_ActivateKeys Test ************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    

	/* calling the HMAC ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = HOSTQA_ATP_Message(TST_Host_opCode,sizeof(TST_Ext_KeysRSA_TestDataStruct),(void*)&SEP_KeysOpRSA_Ver15_TestData[0]);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"HOSTQA_ATP_Message","KMNG_ExtApp_ATP_RSA_V15_ActivateKeys",TST_MasterTestName);                   

    return TST_TestStatus;                
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description: 
 *  This function Is an acceptance test for Key management API's,
 *  implemented as external SEP application.
 *  The function tests the RSA PRIME encrypt decrypt, sign verify operations on RSA keys.                          .
 * Algorithm:       
 * 1. Call the HOSTQA_ATP_Message function to execute test
 * 2. Verify function succeded according to the returned error code                                                                
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxError_t             TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys";     
                              
    DxUint32_t            TST_Host_opCode = DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_PRIME_ActivateKey;
                              
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys Test ************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    

	/* calling the ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = HOSTQA_ATP_Message(TST_Host_opCode,sizeof(TST_Ext_KeysRSA_TestDataStruct),(void*)&SEP_KeysOpRSA_Ver15_TestData[0]);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"HOSTQA_ATP_Message","KMNG_ExtApp_ATP_RSA_PRIME_ActivateKeys",TST_MasterTestName);                   

    return TST_TestStatus;                
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ExtApp_ATP_RSA_V21_ActivateKeys      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description: 
 *  This function Is an acceptance test for Key management API's,
 *  implemented as external SEP application.
 *  The function tests the RSA v21 operations on RSA keys.                          .
 * Algorithm:       
 * 1. Call the HOSTQA_ATP_Message function to execute test
 * 2. Verify function succeded according to the returned error code                                                                
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_RSA_V21_ActivateKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxError_t             TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_RSA_V21_ActivateKeys";     
                              
    DxUint32_t            TST_Host_opCode = DX_SEP_HOST_SEP_PROTOCOL_HOST_KMNG_RSA_V21_ActivateKey;
                              
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_RSA_V21_ActivateKeys Test ************** \n"));      
    ATP_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    

	/* calling the HMAC ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = HOSTQA_ATP_Message(TST_Host_opCode,sizeof(TST_Ext_KeysRSA_TestDataStruct),(void*)&SEP_KeysOpRSA_Ver21_TestData[0]);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"HOSTQA_ATP_Message","KMNG_ExtApp_ATP_RSA_V21_ActivateKeys",TST_MasterTestName);                   

    return TST_TestStatus;                
}



/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/


